/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.UpgradeShineEffect;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class LivingWall
extends AbstractImageEvent {
    public static final String ID = "Living Wall";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Living Wall");
    public static final String NAME = LivingWall.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = LivingWall.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = LivingWall.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String RESULT_DIALOG = DESCRIPTIONS[1];
    private CurScreen screen = CurScreen.INTRO;
    private boolean pickCard = false;
    private Choice choice = null;

    public LivingWall() {
        super(NAME, DIALOG_1, "images/events/livingWall.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1]);
        if (AbstractDungeon.player.masterDeck.hasUpgradableCards().booleanValue()) {
            GenericEventDialog.setDialogOption(OPTIONS[2]);
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[7], true);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.pickCard && !AbstractDungeon.isScreenUp && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            switch (this.choice) {
                case FORGET: {
                    CardCrawlGame.sound.play("CARD_EXHAUST");
                    AbstractDungeon.topLevelEffects.add(new PurgeCardEffect(AbstractDungeon.gridSelectScreen.selectedCards.get(0), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                    AbstractDungeon.player.masterDeck.removeCard(AbstractDungeon.gridSelectScreen.selectedCards.get(0));
                    break;
                }
                case CHANGE: {
                    AbstractCard c = AbstractDungeon.gridSelectScreen.selectedCards.get(0);
                    AbstractDungeon.player.masterDeck.removeCard(c);
                    AbstractDungeon.transformCard(c);
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getTransformedCard(), c.current_x, c.current_y));
                    break;
                }
                case GROW: {
                    AbstractDungeon.effectsQueue.add(new UpgradeShineEffect((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    AbstractDungeon.gridSelectScreen.selectedCards.get(0).upgrade();
                    AbstractDungeon.player.bottledCardUpgradeCheck(AbstractDungeon.gridSelectScreen.selectedCards.get(0));
                }
            }
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            this.pickCard = false;
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        this.choice = Choice.FORGET;
                        AbstractDungeon.gridSelectScreen.open(CardGroup.getGroupWithoutBottledCards(AbstractDungeon.player.masterDeck.getPurgeableCards()), 1, OPTIONS[3], false, false, false, true);
                        this.logMetric("Forget");
                        break;
                    }
                    case 1: {
                        this.choice = Choice.CHANGE;
                        AbstractDungeon.gridSelectScreen.open(CardGroup.getGroupWithoutBottledCards(AbstractDungeon.player.masterDeck.getPurgeableCards()), 1, OPTIONS[4], false, true, false, false);
                        this.logMetric("Change");
                        break;
                    }
                    default: {
                        AbstractDungeon.gridSelectScreen.open(AbstractDungeon.player.masterDeck.getUpgradableCards(), 1, OPTIONS[5], true, false, false, false);
                        this.choice = Choice.GROW;
                        this.logMetric("Grow");
                    }
                }
                this.pickCard = true;
                GenericEventDialog.updateBodyText(RESULT_DIALOG);
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[6]);
                this.screen = CurScreen.RESULT;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum Choice {
        FORGET,
        CHANGE,
        GROW;

    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

